#include <stdio.h>
#include <stdlib.h>

typedef struct {
    int value;
    int index;
} ValueIndexPair;

int compare_by_value(const void* a, const void* b) {
    ValueIndexPair* pair_a = (ValueIndexPair*)a;
    ValueIndexPair* pair_b = (ValueIndexPair*)b;
    return pair_a->value - pair_b->value;
}

int compare_by_index(const void* a, const void* b) {
    ValueIndexPair* pair_a = (ValueIndexPair*)a;
    ValueIndexPair* pair_b = (ValueIndexPair*)b;
    return pair_a->index - pair_b->index;
}

int get_pairs(int arr[], int size) {
    if (size < 2) {
        return 0;
    }

    ValueIndexPair* pairs = (ValueIndexPair*)malloc(size * sizeof(ValueIndexPair));
    if (!pairs) {
        return -1;
    }

    for (int i = 0; i < size; i++) {
        pairs[i].value = arr[i];
        pairs[i].index = i; 
    }

    qsort(pairs, size, sizeof(ValueIndexPair), compare_by_value);

    int* rank = (int*)malloc(size * sizeof(int));
    if (!rank) {
        free(pairs);
        return -1;
    }

    rank[0] = 0;
    for (int i = 1; i < size; i++) {
        rank[i] = (pairs[i].value == pairs[i-1].value) ? rank[i-1] : rank[i-1] + 1;
    }

    for (int i = 0; i < size; i++) {
        pairs[i].value = rank[i];
    }

    qsort(pairs, size, sizeof(ValueIndexPair), compare_by_index);

    int pair_count = 0;
    for (int i = 0; i < size - 1; i++) {
        if (pairs[i+1].value == pairs[i].value + 1 && arr[i+1] > arr[i]) {
            pair_count++;
        }
    }

    free(pairs);
    free(rank);

    return pair_count;
}

int main() {
    int N, Q;
    scanf("%d%d", &N, &Q);

    int P[N];
    for (int i=0; i<N; i++) {
        scanf("%d", &P[i]);
    }

    int swap_i[Q], swap_j[Q];
    for (int i=0; i<Q; i++) {
        scanf("%d%d", &swap_i[i], &swap_j[i]);
    }

    for (int i=0; i<Q; i++) {
        printf("%d\n", (N - 1) - get_pairs(P, N));

        int index1 = swap_i[i] - 1;
        int index2 = swap_j[i] - 1;
        int temp = P[index1];
        P[index1] = P[index2];
        P[index2] = temp;
    }

    printf("%d\n", (N - 1) - get_pairs(P, N));
    return 0;
}